<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Controller\Customer;

use XCart\Extender\Mapping\Extender;
use XC\MailChimp\Core;

/**
 * Top menu widget
 * @Extender\Mixin
 */
abstract class Profile extends \XLite\Controller\Customer\Profile
{
    /**
     * Postprocess register action (success)
     *
     * @return array
     */
    protected function postprocessActionRegisterSuccess()
    {
        $params = parent::postprocessActionRegisterSuccess();

        if (\XC\MailChimp\Main::isMailChimpConfigured()) {
            $subscribeToAll = \XLite\Core\Request::getInstance()->{Core\MailChimp::SUBSCRIPTION_TO_ALL_FIELD_NAME};

            if ($subscribeToAll) {
                /** @var \XLite\Model\Profile $profile */
                $profile = $this->getModelForm()->getModelObject();

                if ($profile) {
                    try {
                        Core\MailChimp::processSubscriptionAll($profile);
                    } catch (Core\MailChimpException $e) {
                        \XLite\Core\TopMessage::addError(Core\MailChimp::getMessageTextFromError($e));
                    }
                }

                \XLite\Core\Session::getInstance()->{Core\MailChimp::SUBSCRIPTION_TO_ALL_FIELD_NAME} = null;
            }
        }

        return $params;
    }
}
