<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Controller\Admin;

use XC\MailChimp\Core;
use XLite\Controller\Admin\ProfilePageTitleTrait;

/**
 * MailChimp customer subscriptions
 */
class MailchimpSubscriptions extends \XLite\Controller\Admin\AAdmin
{
    use ProfilePageTitleTrait;

    /**
     * Check controller visibility
     *
     * @return boolean
     */
    protected function isVisible()
    {
        return \XC\MailChimp\Main::isMailChimpConfigured();
    }

    /**
     * Return the current page title (for the content area)
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->getTitleString(
            $this->getProfile()
        );
    }

    protected function doNoAction()
    {
        parent::doNoAction();

        $profile = $this->getProfile();
        if ($profile) {
            \XLite\Core\Request::getInstance()->profile_type = $profile->isAdmin() ? 'A' : 'C';
        }
    }

    /**
     * Do action "update"
     *
     * @return void
     */
    protected function doActionUpdate()
    {
        try {
            Core\MailChimp::processSubscriptionInput(
                $this->getProfile(),
                \XLite\Core\Request::getInstance()->{Core\MailChimp::SUBSCRIPTION_FIELD_NAME}
            );
        } catch (Core\MailChimpException $e) {
            \XLite\Core\TopMessage::addError(Core\MailChimp::getMessageTextFromError($e));
        }
    }

    /**
     * Get profile
     *
     * @return \XLite\Model\Profile
     */
    protected function getProfile()
    {
        return \XLite\Core\Database::getRepo('XLite\Model\Profile')->find(
            \XLite\Core\Request::getInstance()->profile_id
        );
    }
}
