<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Controller\Admin;

use XC\MailChimp\Core;
use XLite\Controller\TitleFromController;

/**
 * MailChimp mail lists
 */
class MailchimpLists extends \XLite\Controller\Admin\AAdmin
{
    /**
     * @return string
     */
    public function getTitle()
    {
        return new TitleFromController('mailchimp_options');
    }

    /**
     * Preprocessor for no-action run
     */
    protected function doNoAction()
    {
        Core\MailChimp::getInstance()->updateMailChimpLists();
    }

    /**
     * Preprocessor update action
     */
    protected function doActionUpdate()
    {
        $data = \XLite\Core\Request::getInstance()->data;

        foreach ($data as $id => $value) {
            /** @var \XC\MailChimp\Model\MailChimpList $mailChimpList */
            $mailChimpList = \XLite\Core\Database::getRepo('XC\MailChimp\Model\MailChimpList')
                ->find($id);

            if (!is_null($mailChimpList)) {
                $mailChimpList->setEnabled((int) $value['enabled']);
                $mailChimpList->setSubscribeByDefault((int) $value['subscribe_by_default']);

                $default = 0;
                if (
                    Core\MailChimp::isSelectBoxElement()
                    && $mailChimpList->getId() == \XLite\Core\Request::getInstance()->default_list
                ) {
                    $default = 1;
                } elseif (!Core\MailChimp::isSelectBoxElement()) {
                    $default = ($value['subscribe_by_default'] == 1) ? 1 : 0;
                }

                $mailChimpList->setSubscribeByDefault($default);

                \XLite\Core\Database::getEM()->persist($mailChimpList);
            }
        }

        $delete = \XLite\Core\Request::getInstance()->delete;

        if (
            isset($delete)
            && !empty($delete)
        ) {
            foreach ($delete as $id => $value) {
                $mailChimpList = \XLite\Core\Database::getRepo('XC\MailChimp\Model\MailChimpList')
                    ->find($id);

                if (
                    $value
                    && $mailChimpList->getIsRemoved()
                ) {
                    $mailChimpList->delete();
                }
            }
        }

        \XLite\Core\Database::getEM()->flush();
    }
}
