<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\Controller;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Request;
use XLite\Core\Config;

/**
 * @Extender\Mixin
 */
class AController extends \XLite\Controller\AController
{
    /**
     * @inheritDoc
     */
    protected function run()
    {
        parent::run();

        if (Config::getInstance()->XC->MailChimp->analytics360enabled) {
            Request::getInstance()->processECommerce360Data();
            Request::getInstance()->tryToFillLandingSite();
        }
    }
}
