<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\MailChimp\API\Endpoint\Profile\Transformer;

use XC\MailChimp\Model\MailChimpGroupName;
use XC\MailChimp\Model\MailChimpList;
use XC\MailChimp\Model\MailChimpSegment;
use XCart\Extender\Mapping\Extender;
use XLite\API\Endpoint\Profile\DTO\ProfileOutput as OutputDTO;
use XLite\API\Endpoint\Profile\Transformer\OutputTransformer as ExtendedOutputTransformer;
use XC\MailChimp\API\Endpoint\Profile\DTO\ProfileOutput as ModuleOutputDTO;
use XC\MailChimp\Model\Profile as Model;

/**
 * @Extender\Mixin
 */
class OutputTransformer extends ExtendedOutputTransformer
{
    /**
     * @param Model $object
     */
    public function transform($object, string $to, array $context = []): OutputDTO
    {
        /** @var ModuleOutputDTO $dto */
        $dto = parent::transform($object, $to, $context);

        $dto->mail_chimp_lists = [];
        /** @var MailChimpList $subEntity */
        foreach ($object->getMailChimpLists() as $subEntity) {
            $dto->mail_chimp_lists[] = $subEntity->getId();
        }

        $dto->mail_chimp_interests = [];
        /** @var MailChimpGroupName $subEntity */
        foreach ($object->getMailChimpInterests() as $subEntity) {
            $dto->mail_chimp_interests[] = $subEntity->getId();
        }
        $dto->mail_chimp_segments = [];
        /** @var MailChimpSegment $subEntity */
        foreach ($object->getMailChimpSegments() as $subEntity) {
            $dto->mail_chimp_interests[] = $subEntity->getId();
        }

        return $dto;
    }
}
