/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Sign Up button controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function PopupButtonSignUp()
{
  PopupButtonSignUp.superclass.constructor.apply(this, arguments);
}

extend(PopupButtonSignUp, PopupButton);

PopupButtonSignUp.prototype.pattern = '.sign-up-button';

decorate(
  'PopupButtonSignUp',
  'callback',
  function (selector)
  {
    jQuery('form', selector).each(
      function() {
        let form = jQuery(this);
        form.change(function () {
          let hasEmpty = false;
          form.find('input:visible, select:visible, textarea:visible').each(function () {
            if (jQuery(this).val() === '') {
              hasEmpty = true;
            }
          });

          form.find('button.submit:visible').attr('disabled', hasEmpty);
        });
        xcart.bind(
          'switchNextStep',
          function() {
            jQuery('#register_step_first').val(0);
            jQuery('.register-step').toggleClass('hidden');
          }
        );

        xcart.bind(
          'switchPrevStep',
          function() {
            jQuery('#register_step_first').val(1);
            jQuery('.register-step').toggleClass('hidden');
          }
        );

        xcart.bind(
          'reloadOnSuccess',
          function() {
            window.location.reload();
          }
        );
      }
    );
  }
);

xcart.autoload(PopupButtonSignUp);
