<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\IdealPayments\View\FormField\Select;

/**
 * Issuer selector widget
 */
class Issuer extends \XLite\View\FormField\Select\Regular
{
    /**
     * getDefaultOptions
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        $list = [];

        $processor = new \XC\IdealPayments\Model\Payment\Processor\IdealProfessional();

        $issuers = $processor->doIssuerRequest();

        if (is_array($issuers)) {
            foreach ($issuers as $key => $value) {
                $list[$key] = $value;
            }
        }

        return $list;
    }
}
