<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\GoogleFeed\Model\Repo;

use JetBrains\PhpStorm\Deprecated;
use XCart\Extender\Mapping\Extender;
use XC\GoogleFeed\Core\EventListener\FeedGeneration;

/**
 * Abstract repository
 * @Extender\Mixin
 */
class ARepo extends \XLite\Model\Repo\ARepo
{
    /**
     * Define items iterator
     *
     * @param int $position Position OPTIONAL
     *
     * @return \Doctrine\ORM\Internal\Hydration\IterableResult
     */
    public function getFeedGenerationIterator($position = 0)
    {
        return $this->defineFeedGenerationQueryBuilder()
            ->setFirstResult($position)
            ->setMaxResults(FeedGeneration::CHUNK_LENGTH)
            ->iterate();
    }

    /**
     * @param int $position Position @deprecated since XC-GoogleFeed 5.5.1.2
     *
     * @return \XLite\Model\QueryBuilder\AQueryBuilder
     */
    protected function defineFeedGenerationQueryBuilder(#[Deprecated] $position = null)
    {
        if ($position !== null) {
            trigger_deprecation('XC-GoogleFeed', '5.5.1.2', 'Calling "%s" with argument $position is deprecated.', __METHOD__);
        }

        return $this->createPureQueryBuilder();
    }

    /**
     * Define query builder for COUNT query
     *
     * @return \Doctrine\ORM\QueryBuilder|\XLite\Model\QueryBuilder\AQueryBuilder
     */
    protected function defineCountForFeedGenerationQuery()
    {
        $qb = $this->defineFeedGenerationQueryBuilder();

        return $qb->select(
            'COUNT(DISTINCT ' . $qb->getMainAlias() . '.' . $this->getPrimaryKeyField() . ')'
        );
    }

    /**
     * Count items for sitemap generation
     *
     * @return int
     */
    public function countForFeedGeneration()
    {
        return (int) $this->defineCountForFeedGenerationQuery()->getQuery()->getSingleScalarResult();
    }
}
