<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\GoogleFeed\Logic\Import\Processor;

use XCart\Extender\Mapping\Extender;

/**
 * Products
 * @Extender\Mixin
 */
class Products extends \XLite\Logic\Import\Processor\Products
{
    // {{{ Columns
    /**
     * @return array
     */
    public static function getMessages()
    {
        return parent::getMessages() + [
                'PRODUCT-GOOGLE-FEED-ENABLED-FMT' => 'Wrong "google feed enabled" format',
            ];
    }
    // }}}

    // {{{ Verification
    /**
     * @return array
     */
    protected function defineColumns()
    {
        $columns = parent::defineColumns();

        $columns['googleFeedEnabled'] = [];

        return $columns;
    }

    /**
     * Verify 'googleFeedEnabled' value
     *
     * @param array $column Column info
     */
    protected function verifyGoogleFeedEnabled(mixed $value, array $column): void
    {
        if (!$this->verifyValueAsEmpty($value) && !$this->verifyValueAsBoolean($value)) {
            $this->addWarning('PRODUCT-GOOGLE-FEED-ENABLED-FMT', ['column' => $column, 'value' => $value]);
        }
    }

    // }}}

    // {{{ Import
    /**
     * @param \XLite\Model\Product $model  Product
     * @param string               $value  Value
     * @param array                $column Column info
     */
    protected function importGoogleFeedEnabledColumn(\XLite\Model\Product $model, $value, array $column): void
    {
        $model->setGoogleFeedEnabled($this->normalizeValueAsBoolean($value));
    }
    // }}}
}
