<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\GoogleFeed\Logic\Export\Step;

use XCart\Extender\Mapping\Extender;

/**
 * Products
 * @Extender\Mixin
 */
class Products extends \XLite\Logic\Export\Step\Products
{
    /**
     * @return array
     */
    protected function defineColumns()
    {
        $columns = parent::defineColumns();

        $columns['googleFeedEnabled'] = [];

        return $columns;
    }

    /**
     * Get column value for 'googleFeedEnabled' column
     *
     * @param array   $dataset Dataset
     * @param string  $name    Column name
     * @param integer $i       Sub-column index
     */
    protected function getGoogleFeedEnabledColumnValue(array $dataset, $name, $i)
    {
        return $this->getColumnValueByName($dataset['model'], 'googleFeedEnabled');
    }
}
