<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Geolocation\View\Alert;

use XCart\Domain\ModuleManagerDomain;

/**
 * Shipping settings warning
 */
class ShippingSettingsWarning extends \XLite\View\Alert\Warning
{
    protected ?ModuleManagerDomain $moduleManagerDomain;

    public function __construct(array $params = [])
    {
        $this->moduleManagerDomain = \XCart\Container::getContainer()?->get(ModuleManagerDomain::class);

        parent::__construct($params);
    }

    protected function isVisible()
    {
        return $this->moduleManagerDomain->isEnabled('XC-Geolocation');
    }

    protected function getAlertContent()
    {
        return static::t(
            'Your store uses the addon Geolocation',
            ['geoip-settings-link' => \Includes\Utils\Module\Manager::getRegistry()->getModuleSettingsUrl('XC', 'Geolocation')]
        );
    }
}
