<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Geolocation\Core;

use Includes\Utils\ArrayManager;
use XC\Geolocation\Logic\GeoInput\IpAddress;
use XC\Geolocation\Logic\Geolocation;
use XCart\Extender\Mapping\Extender;
use XLite\Core\Database;
use XLite\Model\Country;
use XLite\Model\Language;

/**
 * @Extender\Mixin
 */
class Session extends \XLite\Core\Session
{
    /**
     * @return string
     */
    protected function defineCurrentLanguage()
    {
        $languages = Database::getRepo(Language::class)?->findActiveLanguages();

        if (!empty($languages) && !\XLite::isAdminZone()) {
            $data = Geolocation::getInstance()->getLocation(new IpAddress());

            if (isset($data['country'])) {
                $language = Database::getRepo(Country::class)?->find($data['country'])?->getLanguage();

                if ($language) {
                    $result = ArrayManager::searchInObjectsArray(
                        $languages,
                        'getCode',
                        $language->getCode()
                    );
                }
            }
        }

        return isset($result)
            ? $result->getCode()
            : parent::defineCurrentLanguage();
    }
}
