<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\FreeShipping\LifetimeHook\Upgrade;

use XCart\Doctrine\FixtureLoader;
use XLite\Model\Repo\Shipping\Method as ShippingMethodRepo;
use XLite\Model\Shipping\Method;

final class UpgradeTo550build0
{
    public function __construct(
        private FixtureLoader $fixtureLoader
    ) {
    }

    public function onUpgrade(): void
    {
        $this->setModuleForShippingEntity();
        $this->fixtureLoader->loadYaml(LC_DIR_MODULES . 'XC/FreeShipping/resources/hooks/upgrade/5.5/0.0/upgrade.yaml');
    }

    private function setModuleForShippingEntity(): void
    {
        /** @var ShippingMethodRepo $repo */
        $repo                = \XLite\Core\Database::getRepo(Method::class);
        $shippingMethodCodes = ['FREESHIP', 'FIXEDFEE'];

        foreach ($shippingMethodCodes as $code) {
            $shippingMethod = $repo->findOneBy([
                'code' => $code,
            ]);

            if ($shippingMethod) {
                /** @var Method $shippingMethod */
                $shippingMethod->setModule('XC\FreeShipping');
            }
        }
    }
}
