<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\FreeShipping;

use Symfony\Component\DependencyInjection\Compiler\PassConfig;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;
use XC\FreeShipping\DependencyInjection\Compiler\ChangeCouponTypesPass;

final class FreeShippingBundle extends Bundle
{
    public function build(ContainerBuilder $container): void
    {
        parent::build($container);

        $bundles = $container->getParameter('kernel.bundles');

        if (isset($bundles['CouponsBundle'])) {
            $container->addCompilerPass(new ChangeCouponTypesPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 710);
        }
    }
}
