<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ForestGreenSkin;

abstract class Main extends \XLite\Module\AModuleSkin
{
    /**
     * Check if skin is based on Crisp White theme
     *
     * @return boolean
     */
    public static function isCrispWhiteBasedSkin()
    {
        return true;
    }

    /**
     * Returns image sizes
     *
     * @return array
     */
    public static function getImageSizes()
    {
        return [
            \XLite\Logic\ImageResize\Generator::MODEL_LOGO => [
                'Default' => [163, 30],
                'Invoice' => [330, 180]
            ],
        ];
    }

    /**
     * Check if image lazy loading is supported by skin
     *
     * @return boolean
     */
    public static function isUseLazyLoad()
    {
        return true;
    }
}
