/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * navigation.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */
define(
  'checkout_fastlane/navigation',
 ['vue/vue', 'vue/vuex', 'vue/eventbus'],
  function (Vue, Vuex, EventBus) {

  var Navigation = Vue.extend({
    name: 'navigation',

    data: function () {
      return {
        start_with: null,
      }
    },

    computed: _.extend(
      Vuex.mapGetters([
        'sections'
      ]),{

        currentIndex: function () {
          var item = this.$children.find(function (item) {
            return item.isActive;
          });

          return item ? item.index : 0;
        }
      }),

    methods: _.extend(
      Vuex.mapActions([
        'dispatchSwitch',
        'toggleSection'
      ]), {

        getStartSection: function () {
          var target = null;

          if (this.start_with !== null) {
            target = this.$children.find(function (item) {
              return item.name === this.start_with;
            }.bind(this));

          } else if (sessionStorage.getItem('flc_last_uid') === this.$root.uid
            && sessionStorage.getItem('flc_last_visited_section')) {
            target = this.$children.find(function (item) {
              return item.name === sessionStorage.getItem('flc_last_visited_section');
            });
          }

          return target || this.$children[0];
        }
      }),

    events: {
      requestNext: function () {
        if (this.sections.current.complete) {

          var self = this;
          var next = this.$children.find(function (item) {
            return item.index > self.currentIndex;
          });

          if (!next.isEnabled) {
            this.toggleSection({name: next.name, value: true});
          }

          this.$nextTick(function () {
            EventBus.$emit('switchTo', next);
          })
        }
      },

      switchTo: function (target) {
        if (_.isObject(target)) {
          target = target.name;
        }

        this.dispatchSwitch(target);

        this.$nextTick(function () {
          EventBus.$emit('sectionSwitch', target);
          // noinspection JSCheckFunctionSignatures
          sessionStorage.setItem('flc_last_uid', this.$root.uid);
          sessionStorage.setItem('flc_last_visited_section', target);
        })
      },

      checkStartSection: function () {
        var target = this.getStartSection();

        var sectionsToEnable = this.$children.filter(function (item) {
          return item.index <= target.index;
        });

        sectionsToEnable.forEach(function (item) {
          if (!item.isEnabled) {
            this.toggleSection({name: item.name, value: true});
          }
        }.bind(this));

        EventBus.$emit('switchTo', target);
      }
    },
  });

  return Navigation;
});
