/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * navigation-item.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */
define(
  'checkout_fastlane/navigation/item',
 ['vue/vue',
  'vue/vuex',
  'vue/eventbus',
  'checkout_fastlane/navigation'],
  function (Vue, Vuex, EventBus, Navigation) {

  var NavigationItem = Vue.extend({
    name: 'navigation-item',
    props: ['name', 'index'],

    data: function () {
      return {
        blockers: [],
      };
    },

    watch: {
      isEnabled: function (state) {
        jQuery(this.$el).toggleClass('disabled', !state);
      },

      isActive: function (state) {
        if (state) {
          jQuery(this.$refs.link).tab('show');
          if (this.interacted && !window.matchMedia("(min-width: 768px)").matches) {
            var pos = $('.checkout_fastlane_sections').position().top;
            $(window).scrollTop(pos);
          }
        }
      }
    },

    computed: _.extend(
      Vuex.mapGetters([
        'sections'
      ]),{

        isActive: {
          cache: false,
          get: function () {
            return this.sections.current === this.sections.list[this.name];
          }
        },

        isEnabled: {
          cache: false,
          get: function () {
            return _.contains(this.sections.enabled, this.name) && _.isEmpty(this.blockers);
          }
        }
      }),

    events: {
      reloadingBlock: function (level) {
        if (this.index > level) {
          this.blockers.push(level);
        }
      },

      checkoutInteracted: function() {
        this.interacted = true;
      },

      reloadingUnblock: function (level) {
        if (this.index > level) {
          this.blockers.pop();
        }
      },
    },

    mounted: function () {
      this.assignTabHandlers();
    },

    methods: {
      assignTabHandlers: function () {
      },

      triggerSwitch: function () {
        if (this.isEnabled && !this.isActive) {
          this.interacted = true;
          EventBus.$emit('switchTo', this.name);
        }
      }
    }
  });

  Vue.registerComponent(Navigation, NavigationItem);

  return NavigationItem;
});
