/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * sections.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */
define(
  'checkout_fastlane/sections',
  ['vue/vue',
   'vue/vuex',
   'checkout_fastlane/blocks/address'],
  function (Vue, Vuex, Address) {

    var Sections = Vue.extend({
      name: 'sections',
    	replace: false,

      mounted: function () {
        var self = this;
        this.$nextTick(function () {
          $(self.$el).find('.checkout_fastlane_details_box').removeClass('loading');
          jQuery('[data-toggle="tooltip"]').tooltip();
        });
      },

      methods: _.extend(
        Vuex.mapActions([
          'dispatchSwitch'
        ]),{

          switchTo: function (target) {
            this.dispatchSwitch(target);
          },
        }),

      computed: _.extend(
        Vuex.mapGetters([
          'current'
        ]), {

          classes: function () {
            var obj = {};
            if (this.current !== null) {
              obj['section-' + this.current.name] = true;
            }

            return obj;
          },
        }),
    });

    Vue.registerComponent(Sections, Address);

    return Sections;
  }
);
