/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * section.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */
define('checkout_fastlane/sections/section_mixin', ['vue/vuex', 'vue/eventbus'], function (Vuex, EventBus) {
  return {
    data: function () {
      return {
        name: '',
        endpoint: {},
        request_options: {
          rpc: true
        }
      }
    },

    props: [
      'nextLabel'
    ],

    computed: Vuex.mapGetters(['total_text']),

    created: function () {
      this.registerSection({name: this.name, component: this});

      EventBus.$on('update', _.bind(function (event) {
        var isComplete = this.$children.every(function (child) {
          return _.isUndefined(child.isValid) || child.isValid;
        });

        if (isComplete !== this.complete) {
          this.toggleComplete({name: this.name, value: isComplete});
        }

        this.$root.$broadcast('sectionUpdate', this.name);

        if (!event.silent) {
          _.debounce(this.persist, 300).call(this, event.fields, event.force, event.sender);
        }
      }, this));
    },

    methods: _.extend(
      Vuex.mapActions([
        'dispatchSwitch',
        'registerSection',
        'toggleComplete',
      ]),{

      switchTo: function (target) {
        this.dispatchSwitch(target);
      },

      persist: function (fields, force, sender) {
        if (
          (force || this.complete)
          && !_.isEmpty(fields)
          && (!fields.action || fields.action === this.endpoint.action)
        ) {
          this.$broadcast('beforeSectionPersist', {sender: sender});

          var data = JSON.parse(JSON.stringify(fields));
          data[xliteConfig.form_id_name] = xliteConfig.form_id;

          $.when(this.xhr || true).then(_.bind(function() {
            this.xhr =  xcart.post(
              this.endpoint,
              null,
              data,
              this.request_options
              )
              .done(
                _.bind(function(data){
                  xcart.trigger('checkout.sections.' + this.name + '.persist', {status: true, data: data, sender: sender});
                  this.$broadcast('sectionPersist', {status: true, data: data, sender: sender});
                }, this)
              )
              .fail(
                _.bind(function(xhr, status){
                  if (status !== 'abort') {
                    xcart.showError('Server connection error. Please check your Internet connection.');
                    xcart.trigger('checkout.sections.' + this.name + '.persist', {status: false, data: null, sender: sender});
                    this.$broadcast('sectionPersist', {status: false, data: data, sender: sender});
                  }
                }, this)
              );
          }, this));
        }
      }
    })
  }
})
