/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * component.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */
define(
  'checkout_fastlane/sections/address',
  ['vue/vue',
   'checkout_fastlane/sections',
   'checkout_fastlane/sections/section_mixin'],
  function (Vue, Sections, SectionMixin) {

  var AddressSection = Vue.extend({
    mixins: [SectionMixin],
    name: 'address-section',
    replace: false,

    data: function () {
      return {
        index: 0,
        name: 'address',
        endpoint: {
          target: 'checkout',
          action: 'update_profile'
        },
      };
    },

    created: function () {
      var registeredHandlers = {};

      var updateHandler = _.bind(function (event) {
        var isComplete = this.$children.every(function (child) {
          return _.isUndefined(child.isValid) || child.isValid;
        });

        if (isComplete !== this.complete) {
          this.toggleComplete({name: this.name, value: isComplete});
        }

        this.$root.$broadcast('sectionUpdate', this.name);

        if (!event.silent) {
          _.debounce(this.persist, 300).call(this, event.fields, event.force, event.sender);
        }
      }, this);

      this.$on('update', function (event) {
        if (registeredHandlers[event.sender.$options.name] === undefined) {
          registeredHandlers[event.sender.$options.name] = _.debounce(updateHandler, 1000);
        }

        registeredHandlers[event.sender.$options.name](event);
      });
    },

    mounted: function () {
      this.updateStates();
    },

    computed: {
      complete: function () {
        window.addEventListener('popstate', function () {
          var sections = Checkout.instance.getState().sections;
          sections.current = sections.list.address;
        });

        return this.$store.state.sections.list.address.complete;
      }
    },

    methods: {
      updateStates: function () {
        if (typeof StateSelector !== 'undefined') {
          StateSelector.updateStateValueOnce = true;
          StatesList.getInstance().updateStatesList();
        }
      }
    },

    events: {
      trigger_email_check: function (event) {
        var data = {
          'email': event.email
        };

        data[xliteConfig.form_id_name] = xliteConfig.form_id;

        $.when(this.xhr).then(_.bind(function() {
          this.xhr = xcart.post(
            this.endpoint,
            null,
            data,
            this.request_options
          )
          .fail(function(){
            xcart.showError('Server connection error. Please check your Internet connection.');
          });
        }, this));
      }
    },
  });

  Vue.registerComponent(Sections, AddressSection);

  return AddressSection;
});
