/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * sections.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */
define('checkout_fastlane/store/sections', ['vue/vue'], function (Vue) {
	return {
    state: {
      current: null,
      enabled: [],
      list: {},
    },

    mutations: {
      REGISTER_SECTION: function (state, payload) {
        var name = payload.name;
        var component = payload.component;
        Vue.set(state.list, name, {});
        Vue.set(state.list[name], 'fields',     {});
        Vue.set(state.list[name], 'complete',   false);
        Vue.set(state.list[name], 'name',       name);
        Vue.set(state.list[name], 'index',      component.index);
        Vue.set(state.list[name], 'nextLabel',  component.nextLabel);
      },

      SWITCH_SECTION: function (state, name) {
        var oldSection = state.current;
        state.current = state.list[name];

        xcart.trigger('fastlane_section_switched', {
          oldSection: oldSection,
          newSection: state.current
        });
      },

      TOGGLE_SECTION: function (state, payload) {
        if (payload.value) {
          state.enabled.push(payload.name);
        } else {
          var index = state.enabled.indexOf(payload.name);
          state.enabled.splice(index, 1);
        }
      },

      TOGGLE_COMPLETE: function (state, payload) {
        state.list[payload.name].complete = payload.value;
      },

      UPDATE_SECTION_FIELDS: function (state, name, data) {
        state.list[name].fields = _.extend(state.list[name].fields, data);
      },

      UPDATE_TOS_CONSENT: function (state, value) {
        Vue.set(state, 'tos_consent', value);
      },
    },

    getters: {
      current: function (state) {
        return state.current;
      },

      sections: function (state) {
        return state;
      },

      tosConsent: function (state) {
        return typeof state.tos_consent !== 'undefined'
          ? state.tos_consent
          : true
      },

      sections_ready: function (state) {
        return _.values(state.list).every(function (section) {
          return section.complete;
        });
      },

      is_visible: function (state) {
        return state.current && state.current.name === 'payment';
      },
    },

    actions: {
      updateStoreState: function (ctx, payload) {
        ctx.commit('WEBMASTER_MODE_UPDATE_STATE', payload);
      },

      dispatchSwitch: function (ctx, payload) {
        ctx.commit('SWITCH_SECTION', payload);
      },

      registerSection: function (ctx, payload) {
        ctx.commit('REGISTER_SECTION', payload);
      },

      toggleSection: function (ctx, payload) {
        ctx.commit('TOGGLE_SECTION', payload);
      },

      updateTosConsent: function (ctx, value) {
        ctx.commit('UPDATE_TOS_CONSENT', value);
      },

      toggleComplete: function(ctx, payload) {
        ctx.commit('TOGGLE_COMPLETE', payload);
      },

      disablePaymentStep: function (ctx) {
        ctx.commit('TOGGLE_SECTION', {name: 'payment', value: false});
      }
    }
	}
});
