/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * order.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */
define('checkout_fastlane/store/order', [], function () {
	return {
    state: {
      total: 0.0,
      total_text: "",
      shipping_method: null,
      payment_method: null,
      notes: $('order-notes').data('default-value'),
      address: {
        shipping: null,
        billing: null,
      },
      same_address: null,
      paymentData: null,
      includedModifiersData: {}
    },

    mutations: {
      UPDATE_TOTAL: function (state, payload) {
        state.total = payload.number;
        state.total_text = payload.text;
      },

      UPDATE_INCLUDED_MODIFIERS: function (state, modifiersData) {
        state.includedModifiersData = modifiersData;
      },

      UPDATE_SHIPPING_METHOD: function (state, value) {
        state.shipping_method = value;
      },

      UPDATE_SHIPPING_ADDRESS: function (state, value) {
        state.address = _.extend(state.address, {
          shipping: value
        });
      },

      UPDATE_BILLING_ADDRESS: function (state, value) {
        state.address = _.extend(state.address, {
          billing: value
        });
      },

      UPDATE_SAME_ADDRESS: function (state, value) {
        state.same_address = value;
      },

      UPDATE_NOTES: function (state, value) {
        state.notes = value;
      },

      UPDATE_PAYMENT_DATA: function (state, value) {
        state.paymentData = value;
      },
      UPDATE_PAYMENT_METHOD: function (state, value) {
        state.payment_method = value;
      },
    },

    getters: {
      notes: function (state) {
        return state.notes;
      },

      total_text: function (state) {
        return state.total_text;
      },

      included_modifiers_data: function (state) {
        return state.includedModifiersData;
      },

      vuex_address: function (state) {
        return state.address;
      },

      vuex_same_as_shipping: function (state) {
        return state.same_address;
      },

      paymentData: function (state) {
        return state.paymentData;
      },

      order_shipping_method: function (state) {
        return state.shipping_method;
      },
    },

    actions: {
      _updateNotes: function (ctx, value) {
        ctx.commit('UPDATE_NOTES', value);
      },

      updateMethod: function (ctx, value) {
        ctx.commit('UPDATE_SHIPPING_METHOD', value);
      },

      updatePaymentData: function (ctx, value) {
        ctx.commit('UPDATE_PAYMENT_DATA', value);
      },

      updatePaymentMethod: function (ctx, value) {
        ctx.commit('UPDATE_PAYMENT_METHOD', value);
      },

      updateTotal: function (ctx, payload) {
        ctx.commit('UPDATE_TOTAL', payload);
      },

      updateIncludedModifiers: function (ctx, modifiersData) {
        ctx.commit('UPDATE_INCLUDED_MODIFIERS', modifiersData);
      },

      updateShippingAddress: function (ctx, data) {
        ctx.commit('UPDATE_SHIPPING_ADDRESS', data);
      },

      updateSameAddressFlag: function (ctx, value) {
        ctx.commit('UPDATE_SAME_ADDRESS', value);
      },

      updateBillingAddress: function (ctx, data) {
        ctx.commit('UPDATE_BILLING_ADDRESS', data);
      },
    }
	}
});
