/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * shipping-methods.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */
define(
  'checkout_fastlane/blocks/shipping_methods',
 ['vue/vue',
  'vue/vue.loadable',
  'vue/eventbus',
  'checkout_fastlane/sections/shipping'],
  function (Vue, VueLoadableMixin, EventBus, ShippingSection) {

  var shippingMethodInitialLoaded = false;

  var ShippingMethods = Vue.extend({
    mixins: [VueLoadableMixin],
    name: 'shipping-methods',
    replace: false,
    props: ['deferred'],

    data: function () {
      return {
        watcherIsBlocked: false,
        selector: null,
        methodId: null,
      };
    },

    loadable: {
      transferState: false,
      ignoreUpdates: ['methodId'],
      loader: function () {
        this.watcherIsBlocked = true;
        EventBus.$emit('reloadingBlock', 1);
        return xcart.get({
          target: 'checkout',
          widget: 'XC\\FastLaneCheckout\\View\\Blocks\\ShippingMethods'
        }, undefined, undefined, { timeout: 45000 });
      },

      resolve: function () {
        var self = this;
        // updates window.shippingMethodsList
        $.globalEval($('#ShippingMethodsWidgetData').text());
        EventBus.$emit('reloadingUnblock', 1);
        this.$nextTick(function () {
          self.watcherIsBlocked = false;
        })
      },

      reject: function () {
        EventBus.$emit('reloadingUnblock', 1);
        this.watcherIsBlocked = false;
      }
    },

    mounted: function () {
      if (this.deferred && !shippingMethodInitialLoaded) {
        shippingMethodInitialLoaded = true;
        this.$reload();
      } else {
        this.assignChosen();
      }
    },

    computed: {
      classes: function () {
        return {
          'reloading': this.$reloading,
          'reloading-animated': this.$reloading
        }
      },

      isValid: {
        cache: false,
        get: function () {
          return this.methodId;
        }
      }
    },

    watch: {
      methodId: function (value, oldValue) {
        var silent = (oldValue === null || this.watcherIsBlocked);

        if (!silent) {
          this.$reloading = true;
          EventBus.$emit('reloadingBlock', 1);
        }

        this.triggerUpdate({
          silent: silent
        });
      },
    },

    events: {
      sectionPersist: function (data) {
        this.$reloading = false;
        EventBus.$emit('reloadingUnblock', 1);
      },

      global_createshippingaddress: function (data) {
        this.$reload();
      },

      global_updatecart: function (data) {
        var shippingKeys = ['shippingMethodsHash', 'shippingMethodId'];
        var needsUpdate = _.some(shippingKeys, function(key) {
          return _.has(data, key);
        });

        if (needsUpdate) {
          this.$reload();
        }
      },
    },

    methods: _.extend(
      Vuex.mapActions([
        'updateMethod'
      ]),{

        triggerUpdate: function (options) {
          options = options || {};
          var eventArgs = _.extend({
            sender: this,
            isValid: this.isValid,
            fields: this.toDataObject()
          }, options);

          EventBus.$emit('update', eventArgs);
          this.updateMethod(this.methodId);
        },

        toDataObject: function () {
          return {
            action: 'shipping',
            methodId: this.methodId
          };
        },

        onChosenChange: function (select) {
          this.methodId = select.val();
        },

        assignChosen: function () {
          var self = this;
          var select = $(this.$el).find('.selector-view.rich select.rich');
          if (select.length > 0) {
            var options = {};
            if (select.data('disable-search') == 1) {
              options.disable_search = true;
            }
            select.chosen(options).on('change', function (e) {
              self.onChosenChange($(this));
            });
            select.next('.chosen-container').css({
              'width':     'auto',
              'min-width': select.parent().width()
            });
          }
        }
      })
  });

  Vue.registerComponent(ShippingSection, ShippingMethods);

  return ShippingMethods;
});
