/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * payment-methods.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */
define(
  'checkout_fastlane/blocks/payment_methods',
 ['vue/vue',
  'vue/vue.loadable',
  'vue/vuex',
  'checkout_fastlane/sections/payment'],
  function (Vue, VueLoadableMixin, Vuex, PaymentSection) {

  var PaymentMethods = Vue.extend({
    mixins: [VueLoadableMixin],
    name: 'payment-methods',
    replace: false,

    data: function () {
      return {
        watcherIsBlocked: false,
        required: null,
        methodId: null,
        payment: {}
      };
    },

    loadable: {
      transferState: false,
      ignoreUpdates: ['methodId'],
      loader: function () {
        this.watcherIsBlocked = true;
        this.$root.$broadcast('reloadingBlock', 2);
        this.payment = {};
        return xcart.get({
          target: 'checkout',
          widget: 'XC\\FastLaneCheckout\\View\\Blocks\\PaymentMethods'
        }, undefined, undefined, { timeout: 45000 });
      },

      resolve: function() {
        var self = this;
        this.$root.$broadcast('reloadingUnblock', 2);
        this.$nextTick(function () {
          self.watcherIsBlocked = false;
        });
      },

      reject: function() {
        this.$root.$broadcast('reloadingUnblock', 2);
        this.watcherIsBlocked = false;
      }
    },

    created: function () {
      this.form = jQuery();
      this.isInitialChecked = false;
    },

    mounted: function () {
      var self = this;
      this.$nextTick(function () {
        self.form = jQuery('form.payment-form');
        new CommonForm(self.form);
      })

      xcart.trigger('checkout.paymentTpl.postprocess');
      xcart.trigger('checkout.paymentTpl.loaded');

      decorate(
        'PaymentTplView',
        'shade',
        function () {}
      );
    },

    computed: {
      paymentData: function () {
        return _.reduce(
          this.payment,
          function (result, value, key) {
            if (key.lastIndexOf('cc_', 0) === 0) {
              return result;
            }

            var newKey = 'payment[' + key + ']';
            result[newKey] = value;
            return result;
          }, {}
        );
      },

      classes: function () {
        return {
          'reloading': this.$reloading,
          'reloading-animated': this.$reloading
        }
      },

      formIsValid: {
        cache: false,
        get: function() {
          return !_.isEmpty(this.payment)
            ? !_.isUndefined(this.form.get(0).commonController) && this.form.get(0).commonController.validate({
              silent: !this.form.get(0).commonController.wasFilledOnce(),
              focus: false
            })
            : true;
        }
      },

      isValid: {
        cache: false,
        get: function () {
          return this.methodId !== null && this.formIsValid || this.required === false;
        }
      }
    },

    watch: {
      required: function (value, oldValue) {
        this.triggerUpdate({
          silent: oldValue === null,
        });
      },

      methodId: function (value, oldValue) {
        var silent = (oldValue === null || this.watcherIsBlocked);
        if (!silent) {
          this.$reloading = true;
          this.$root.$broadcast('reloadingBlock', 2);
        }
        this.triggerUpdate({
          silent: silent,
          force: true,
        });
      },

      paymentData: _.throttle(function (value, oldValue) {
        this.triggerUpdate({
          silent: true
        });
      }, 300)
    },

    events: {
      sectionSwitch: function (current) {
        if (!this.isInitialChecked && current === 'payment') {
          this.triggerUpdate({
            silent: true,
          });
          this.isInitialChecked = true;
        }
      },

      sectionPersist: function (data) {
        this.$reloading = false;
        this.$root.$broadcast('reloadingUnblock', 2);
      },

      global_updatecart: function (data) {
        var triggerKeys = ['paymentMethodsHash', 'paymentMethodId', 'total'];
        var needsUpdate = _.some(triggerKeys, function (key) {
          return _.has(data, key);
        });

        if (needsUpdate) {
          this.$reload();
        }
      },
    },

    methods: _.extend(
      Vuex.mapActions([
        'updatePaymentData',
        'updatePaymentMethod'
      ]), {

        triggerUpdate: function(options) {
          options = options || {};
          var eventArgs = _.extend({
            sender: this,
            isValid: this.isValid,
            fields: this.toDataObject()
          }, options);

          this.$dispatch('update', eventArgs);
          this.updatePaymentData(this.paymentData);
          this.updatePaymentMethod(this.methodId);
        },

        toDataObject: function() {
          return _.extend({
            action: 'payment',
            methodId: this.methodId
          }, this.paymentData);
        },
      })
  });

  Vue.registerComponent(PaymentSection, PaymentMethods);

  return PaymentMethods;
});
