/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * order-notes.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */
define(
  'checkout_fastlane/blocks/order_notes',
 ['vue/vue', 'vue/vuex'],
  function (Vue, Vuex) {

  return Vue.extend({
    name: 'order-notes',
    replace: false,

    computed: Vuex.mapGetters([
      'notes'
    ]),

    methods: _.extend(
      Vuex.mapActions([
        '_updateNotes'
      ]),{

        updateNotes: function (event) {
          this._updateNotes(event.target.value);
          this.$nextTick(function () {
            $('order-notes textarea').trigger('change');
          });
        },
      }
    )
  });
});
