/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * cart-items.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */
define(
  'checkout_fastlane/blocks/cart_items',
 ['vue/vue',
  'vue/vue.loadable',
  'checkout_fastlane/sections'],
 function (Vue, VueLoadableMixin, Sections) {

  var CartItems = Vue.extend({
    mixins: [VueLoadableMixin],
    name: 'cart-items',
    replace: false,

    loadable: {
      transferState: false,
      cacheSimultaneous: true,
      loader: function () {
        this.$root.$broadcast('reloadingBlock', 3);
        return xcart.get({
          target: 'checkout',
          widget: 'XC\\FastLaneCheckout\\View\\Blocks\\CartItems'
        }, undefined, undefined, { timeout: 45000 });
      },

      resolve: function () {
        this.parseTotal();
        this.parseIncludedModifiers();
        this.$root.$broadcast('reloadingUnblock', 3);
      },

      reject: function () {
        this.$root.$broadcast('reloadingUnblock', 3);
      }
    },

    mounted: function () {
      this.$nextTick(_.bind(function () {
        this.parseTotal();
        this.parseIncludedModifiers();
        xcart.trigger('checkout.cart_items.ready');
      }, this));
    },

    data: function () {
      return {
        itemsVisible: false,
      };
    },

    computed: {
      itemsList: function () {
        return {
          display: this.itemsVisible ? 'block' : 'none',
        }
      }
    },

    methods: _.extend(
      Vuex.mapActions([
        'updateTotal',
        'updateIncludedModifiers'
      ]), {

        toggleItems: function () {
          this.itemsVisible = !this.itemsVisible;
        },

        parseTotal: function () {
          var totalsElement = $('.total .surcharge', this.$el);
          var integer = $('.part-integer', totalsElement).text().replace(/[^0-9]/, '');
          var decimal = $('.part-decimal', totalsElement).text().replace(/[^0-9]/, '');
          var number = parseFloat(integer + '.' + decimal);
          var text = totalsElement.text();

          this.updateTotal({number: number, text: text});
        },

        parseIncludedModifiers: function () {
          var modifiersElement = $('.modifiers.included-modifiers', this.$el);
          var modifiersData = modifiersElement.html();

          this.updateIncludedModifiers(modifiersData);
        }
      }),

    events: {
      global_updatecart: function (data) {
        var triggerKeys = ['shippingTotal', 'total'];
        var needsUpdate = _.some(triggerKeys, function(key) {
          return _.has(data, key);
        });

        if (needsUpdate) {
          this.$reload();
        }
      },

    },
  });

  Vue.registerComponent(Sections, CartItems);

  return CartItems;
});
