/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * address_form.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define(
  'checkout_fastlane/blocks/address_form/billing',
 ['vue/vue',
  'checkout_fastlane/blocks/address_form',
  'checkout_fastlane/sections/address',
  'vue/eventbus'],
  function (Vue, AddressForm, AddressSection, EventBus) {

  var BillingAddressForm = AddressForm.extend({
    name: 'billing-address-form',

    data: function () {
      return _.extend(BillingAddressForm.super.options.data.apply(this, arguments), {
        same_address: window.WidgetData['same_address'],
        visible: !window.WidgetData['same_address']
      });
    },

    created: function () {
      this.shortType = 'b';
      this.fullType = 'billing';

      EventBus.$on('global_selectcartaddress', _.bind(function (data) {
        if (data.same !== !!this.fields.same_address) {
          this.nonPersistMode = true;
          this.same_address = data.same ? 1 : 0;
        }
      }, this));

      EventBus.$on('global_updatecart', _.bind(function (data) {
        if (_.has(data, 'sameAddress') && data['sameAddress'] !== !!this.fields.same_address) {
          this.nonPersistMode = true;
          this.same_address = data['sameAddress'] ? 1 : 0;
        }
      }, this));
    },

    mounted: function () {
      this.updateBillingAddress(this.toDataObject());
    },

    watch: {
      'same_address': function (value, oldValue) {
        if (!value && jQuery.fn.floatingLabel) {
          jQuery('input', this.form).each(function() {
            if (jQuery(this).val()) {
              jQuery(this).floatingLabel();
            }
          });
        }

        this.toggle(!value);

        this.$nextTick(function(){
          jQuery('#billingaddress-country-code').change();

          this.persistSameAsShipping(value, oldValue);
        });
      }
    },

    computed: {
      isStateValid: function () {
        return BillingAddressForm.super.options.computed.isStateValid.get.apply(this, arguments) || this.same_address;
      }
    },

    methods: _.extend(
      Vuex.mapActions([
        'updateSameAddressFlag',
        'updateBillingAddress'
      ]), {

        persistSameAsShipping: _.debounce(function (value, oldValue) {
            var force = oldValue !== null;
            this.$dispatch('modify', value, oldValue, force);
          }, 100
        ),

        preprocess: function (data) {
          if (this.same_address === 1 || !this.isValid) {
            return {
              'same_address': this.same_address
            };
          } else {
            return BillingAddressForm.super.options.methods.preprocess.apply(this, arguments);
          }
        },

        triggerUpdate: function (options) {
          this.updateBillingAddress(this.toDataObject());
          this.updateSameAddressFlag(this.same_address);
          BillingAddressForm.super.options.methods.triggerUpdate.apply(this, arguments);
        },

        toDataObject: function () {
          return _.extend(BillingAddressForm.super.options.methods.toDataObject.apply(this, arguments), {
            'same_address': this.same_address
          });
        },
    })
  });

  Vue.registerComponent(AddressSection, BillingAddressForm);

  return BillingAddressForm;
});
