<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\FacebookMarketing\View;

use Includes\Utils\Module\Manager;
use XCart\Domain\ModuleManagerDomain;

/**
 * Google feed promo banner
 */
class GoogleFeedBanner extends \XLite\View\AView
{
    use \XLite\Core\Cache\ExecuteCachedTrait;

    protected ?ModuleManagerDomain $moduleManagerDomain;

    public function __construct(array $params = [])
    {
        $this->moduleManagerDomain = \XCart\Container::getContainer()?->get(ModuleManagerDomain::class);

        parent::__construct($params);
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/XC/FacebookMarketing/google_feed_banner/body.twig';
    }

    /**
     * @return string
     */
    protected function getGoogleFeedPromoText()
    {
        return static::t('1. Use the addon Google Product Feed for advanced flexibility generating a data feed for Facebook based on the product attributes and variants from your store catalog 2. Generate Product Feed', ['href' => $this->getGoogleFeedModuleLink()]);
    }

    /**
     * @return bool
     */
    protected function isGoogleFeedEnabled()
    {
        return $this->moduleManagerDomain->isEnabled('XC-GoogleFeed');
    }

    /**
     * @return string
     */
    protected function getGoogleFeedModuleLink()
    {
        return $this->isGoogleFeedEnabled()
            ? $this->buildURL('google_shopping_groups')
            : Manager::getRegistry()->getModuleServiceURL('XC', 'GoogleFeed');
    }
}
