<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\CustomProductTabs\Transformer\XLite\Model\Product\Logic\Entity\Storefront;

use XCart\Transformer\XLite\Model\Product\Logic\Entity\Storefront\ProductInterface;
use XLite\Model\Product as Source;
use XCart\Logic\Entity\Storefront\ProductTab;
use XCart\Logic\Entity\Storefront\Product as Target;

class ProductDecorator implements ProductInterface
{
    public function __construct(
        private ProductInterface $inner
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->inner->transform($input);

        $target->setTabs($this->getTransformedTabs($input));

        return $target;
    }

    /**
     * @return ProductTab[]
     */
    private function getTransformedTabs(Source $input): array
    {
        $transformedTabs = [];

        /* @var \XC\CustomProductTabs\Model\Product\Tab $tab */
        foreach ($input->getTabs() as $tab) {
            if ($tab->getEnabled()) {
                $transformedTab = new ProductTab();
                $transformedTab->setName((string) $tab->getName());

                if ($serviceName = $tab->getServiceName()) {
                    $transformedTab->setServiceName($serviceName);
                }

                if ($content = $tab->getContent()) {
                    $transformedTab->setContent($content);
                }

                if ($briefInfo = $tab->getBriefInfo()) {
                    $transformedTab->setBriefInfo($briefInfo);
                }

                $transformedTabs[] = $transformedTab;
            }
        }

        return $transformedTabs;
    }
}
