<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\CustomProductTabs\Model\Repo\Product;

use XC\CustomProductTabs\Model\Product\CustomGlobalTabTranslation;
use XLite\Model\Repo\ModelRepoTranslationTrait;

class CustomGlobalTab extends \XLite\Model\Repo\Base\I18n
{
    use ModelRepoTranslationTrait;

    public function loadFixture(array $record, \XLite\Model\AEntity $parent = null, array $parentAssoc = [])
    {
        $entity = parent::loadFixture($record, $parent, $parentAssoc);

        if (
            $entity->getGlobalTab()
            && !$entity->getGlobalTab()->getLink()
        ) {
            $entity->getGlobalTab()->setLink(
                \XLite\Core\Database::getRepo('\XLite\Model\Product\GlobalTab')->generateTabLink($entity)
            );
        }

        return $entity;
    }

    public function getTranslationDataFromYamlStructure(array $entity, string $lngCode): ?array
    {
        if (
            ($result = $this->getTranslationFromYamlStructure($entity, $lngCode))
            && !empty($result['name'])
        ) {
            return [
                $result['name'],
                $result['brief_info'] ?? '',
                $result['content'] ?? ''
            ];
        }

        return null;
    }

    public function getTranslationDataFromModel(CustomGlobalTabTranslation $translation): ?array
    {
        return [
            $translation->getName(),
            $translation->getBriefInfo(),
            $translation->getContent()
        ];
    }
}
