<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\CustomProductTabs\LifetimeHook\Upgrade;

use XC\CustomProductTabs\Model\Product\CustomGlobalTab;
use XLite\Core\Database;

final class UpgradeTo550build0
{
    public function onUpgrade(): void
    {
        $customGlobalTabs = Database::getRepo(CustomGlobalTab::class)?->findAll();

        foreach ($customGlobalTabs as $customGlobalTab) {
            /** @var CustomGlobalTab $customGlobalTab */
            $customGlobalTab->assignModule();
        }

        Database::getEM()->flush();
    }
}
