<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\CustomProductTabs\LifetimeHook;

use XC\CustomProductTabs\Main;
use XLite\Core\Database;
use XLite\Model\Product;
use XLite\Model\Product\GlobalTab;

final class Rebuild
{
    public function onRebuild(): void
    {
        $qb = Database::getRepo(GlobalTab::class)?->createQueryBuilder();

        $alias = $qb->getMainAlias();
        $qb->addSelect('COUNT(psa.id) as HIDDEN aliases_count')
            ->leftJoin("{$alias}.product_specific_aliases", 'psa')
            ->andWhere("{$alias}.service_name IS NOT NULL")
            ->having('aliases_count < :products_count')
            ->groupBy("{$alias}.id")
            ->setParameter('products_count', Database::getRepo(Product::class)?->count());

        foreach ($qb->getResult() as $globalTab) {
            Database::getRepo(GlobalTab::class)?->createGlobalTabAliases($globalTab);
        }

        Main::removeUninstalledModulesTabs();
    }
}
