<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\CustomProductTabs\LifetimeHook;

use XC\CustomProductTabs\Model\Product\Tab;
use XLite\Core\Database;
use XLite\Model\Product\GlobalTab;

final class Install
{
    public function onInstall(): void
    {
        $queryBuilder = Database::getEM()->createQueryBuilder();
        $queryBuilder->update(GlobalTab::class, 'gt')
            ->set('gt.enabled', 1)
            ->getQuery()
            ->execute();

        $queryBuilder = Database::getEM()->createQueryBuilder();
        $queryBuilder->update(Tab::class, 'pt')
            ->set('pt.enabled', 1)
            ->getQuery()
            ->execute();
    }
}
