<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\CustomProductTabs\Core;

use XC\CustomProductTabs\Model\Product\CustomGlobalTab;
use XC\CustomProductTabs\Model\Product\Tab;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend("XC\CustomProductTabs")
 */
class Translation extends \XLite\Core\Translation
{
    public static function getModelsToExportTranslations(): array
    {
        return array_merge(
            parent::getModelsToExportTranslations(),
            [
                CustomGlobalTab::class,
                Tab::class
            ]
        );
    }
}
