<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\CrispWhiteSkin\View;

use XCart\Extender\Mapping\Extender;
use XLite\Core\PreloadedLabels\ProviderInterface;

/**
 * Slidebar decorator
 * @Extender\Mixin
 */
abstract class Slidebar extends \XLite\View\Slidebar implements ProviderInterface
{
    /**
     * Get a list of JavaScript files required to display the widget properly
     *
     * @return array
     */
    public function getJSFiles()
    {
        $list = parent::getJSFiles();

        $list[] = 'js/slidebar_options.js';

        return $list;
    }

    public function getPreloadedLanguageLabels()
    {
        return parent::getPreloadedLanguageLabels() + [
            'My account' => static::t('My account')
        ];
    }
}
