<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\CrispWhiteSkin\Module\XC\Reviews\View\Customer\ProductInfo\Details;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend("XC\Reviews")
 */
class AverageRating extends \XC\Reviews\View\Customer\ProductInfo\Details\AverageRating
{
    public function getAverageRatingSpanCssClass(): string
    {
        return 'average-rating ' . ($this->getAverageRating() > 0 ? 'rated' : 'not-rated');
    }
}
