/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

decorate(
  'ProductsListView',
  'postprocess',
  function (isSuccess, initial) {
    arguments.callee.previousMethod.apply(this, arguments)

    if (isSuccess) {
      $('.products-grid .product-cell > .product:not(.prevent-hover)').mouseenter(function () {
        let product = jQuery(this)

        let productNameContainer = product.find('h4.product-name')
        let productNameContainerHeight = parseInt(productNameContainer.css('line-height'), 10) * 2 // 2 because of min 2 lines in product name

        let productName = productNameContainer.children('a')
        let productNameHeight = parseInt(productName.css('height'), 10)

        let productMargin    = 0;
        let buttonsContainer = product.find('.buttons-container')

        product.closest('.block.block-block').addClass('hover-within');

        if (buttonsContainer.length) {
          let buttonsContainerSize = parseInt(buttonsContainer.outerHeight(true), 10)
          productMargin = productMargin - buttonsContainerSize
        }

        if (productNameHeight > productNameContainerHeight) {
          let productNameDelta = productNameContainerHeight - productNameHeight;
          product.css({'margin-bottom': productMargin + productNameDelta + 'px'});
        }
      }).mouseleave(function () {
        const self = $(this);
        self.removeAttr('style');
        self.closest('.block.block-block').removeClass('hover-within');
      })
    }
  }
)
