/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

xcart.bind('send-close-wishlist', function(event, data){
  data.link.removeClass("fa-heart").addClass("fa-heart-o");
});

xcart.bind('updateWishlistProductsCount', function(event, data){
  const count = data.count;
  $('#page-title').html(
    xcart.t(
      (Math.abs(count) === 1 ? 'wishlist - X item' : 'wishlist - X items'),
      {
        'name': xcart.t('Private wishlist title') + ' ',
        'count': data.count
      }
    )
  );
  $("title").each(function(i, tag) {
    tag.innerHTML = tag.innerHTML.replace(
      /\s-\s\d+/,
      (count > 0 ? " - " + count.toString() : "")
    );
  });
});
