/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

(function(){

    function getTarget() {
        var wishlist = jQuery('#header div.wishlist');
        var myAccount = jQuery('#header .header_settings');

        return wishlist.length > 0 && wishlist.is(':visible')
            ? wishlist
            : myAccount;
    }

    function flyToWishlist(element) {
        if($(window).width() < 992 || $('body').hasClass('target-product')){
            return;
        }
        var target = getTarget();
        var elementToFly = element;

        var item = getProductRepresentationFor(element);
        console.log(item);
        if (item.element && item.element.length) {
            elementToFly = item.element;
        }

        if (target.length) {
            $(elementToFly).css('pointer-events', 'none');
            $(elementToFly).fly(target, {
                view: item.view,
                callback: function () {
                    $(elementToFly).css('pointer-events', '');
                }
            });
        }
    }

    xcart.microhandlers.add(
        'AddToWishlistFlyTo',
        'a.add-to-wishlist',
        function () {
            var $this = jQuery(this);
            $this.click(function () {
                var productBlock = $this.parents('.product');

                if (productBlock.length) {
                    var productId = $this.data('productid');
                    var allProductBlocksWithId = jQuery('.product.productid-' + productId);
                    allProductBlocksWithId.removeClass('last-clicked');
                    $this.parents('.product').addClass('last-clicked');
                }
            });
        }
    );

    xcart.bind('productaddedtowishlist', function (event, data) {
        var productBlocks = jQuery('.product.productid-' + data.productid);

        var productBlockToFly = productBlocks.filter('.last-clicked');

        if (!productBlockToFly.length) {
            productBlockToFly = productBlocks;
        }

        if (data.isNewAdded === true && !productBlockToFly.parents('.products-table').length) {
            flyToWishlist(productBlockToFly.last());
        }
    });

})();

