/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Single language selector
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

CommonElement.prototype.handlers.push(
  {
    pattern: '.locale_language-selector select[name="country_code"]',
    canApply: function () {
      return 0 < this.$element.filter('.locale_language-selector select[name="country_code"]').length;
    },
    handler: function () {

      const ChangeCountry = function() {
        const commentedData = xcart.getCommentedData(this.$element);
        const languagesByCountry = commentedData['languagesByCountry'];
        if (typeof languagesByCountry[this.$element.val()] != 'undefined') {
          const selectLanguage = $(this.element.form).find('select[name="language"]');
          selectLanguage.val(languagesByCountry[this.$element.val()]);
        }
      };

      const handleChange = this.handleChange;
      this.handleChange = function (event) {
        handleChange.call(this, event);
        ChangeCountry.call(this);
      };
    }
  }
);
