<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\CanadaPost\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XC\CanadaPost\Model\ProductsReturn;

final class ProductsReturnCallback
{
    public function prePersist(ProductsReturn $productsReturn, LifecycleEventArgs $args): void
    {
        $this->prepareBeforeSave($productsReturn);
    }

    public function preUpdate(ProductsReturn $productsReturn, LifecycleEventArgs $args): void
    {
        $this->prepareBeforeSave($productsReturn);
    }

    private function prepareBeforeSave(ProductsReturn $productsReturn): void
    {
        $date = $productsReturn->getDate();
        $newDate = \XLite\Core\Converter::time();

        if (!is_numeric($date) || !is_int($date)) {
            $productsReturn->setDate($newDate);
        }

        $productsReturn->setLastRenewDate($newDate);
    }
}
