<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\CanadaPost\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XC\CanadaPost\Model\DeliveryService;

final class DeliveryServiceCallback
{
    public function prePersist(DeliveryService $deliveryService, LifecycleEventArgs $args): void
    {
        $expiry = $deliveryService->getExpiry();

        if (!is_numeric($expiry) || !is_int($expiry)) {
            $deliveryService->updateExpiry();
        }
    }
}
