<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View;

use XCart\Extender\Mapping\Extender;
use XC\MultiCurrency\Core\MultiCurrency;
use XLite\View\FormField\AFormField;

/**
 * Top menu widget
 *
 * @Extender\Mixin
 * @Extender\Depend("XC\MultiCurrency")
 */
class ProductConfigurationMultiCurrency extends \XC\BuyButton\View\ProductConfiguration
{
    /**
     * @return array
     */
    public function getPanelParams()
    {
        $list = parent::getPanelParams();

        if ($this->canApplyCurrencyParam()) {
            $list['currency'] = [
                'widgetClass' => 'XC\MultiCurrency\View\FormField\Select\Currency\CustomerCurrency',
                'widgetParams' => [
                    AFormField::PARAM_ATTRIBUTES => ['v-model' => 'currency'],
                ]
            ];
        }

        return $list;
    }

    /**
     * @return bool
     */
    protected function canApplyCurrencyParam()
    {
        return MultiCurrency::getInstance()->hasMultipleCurrencies();
    }
}
