<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View;

use XCart\Extender\Mapping\ListChild;
use XC\BuyButton;
use XLite\View\FormField\AFormField;

/**
 * Top menu widget
 *
 * @ListChild (list="admin.center", zone="admin")
 */
class ProductConfiguration extends \XLite\View\AView
{
    /**
     * Return list of allowed targets
     * This widget is displayed only on the featured product selector
     *
     * @return array
     */
    public static function getAllowedTargets()
    {
        return ['buy_button_configure'];
    }

    /**
     * @return array
     */
    public function getJSFiles()
    {
        return [
            BuyButton\Main::getSkinDir() . 'configuration.js',
        ];
    }

    /**
     * @return array
     */
    public function getCSSFiles()
    {
        return [
            [
                'file'  => BuyButton\Main::getSkinDir() . 'style.less',
                'media' => 'screen',
                'merge' => 'bootstrap/css/bootstrap.less',
            ],
            BuyButton\Main::getSkinDir() . 'panel/code_popup.less'
        ];
    }

    /**
     * @return array
     */
    public function getCommonFiles()
    {
        return [
            static::RESOURCE_JS => static::getVueLibraries(),
        ];
    }

    /**
     * Returns KB article url on how to insert buy button on different sites
     *
     * @return string
     */
    protected function getKbUrl()
    {
        return static::t('https://support.x-cart.com/en/collections/2580478-marketing-seo-analytics#buy-button-add-on');
    }

    /**
     * @return array
     */
    protected function getInitialWidgetData()
    {
        return [
            'product' => \XLite::getController()->getProduct()->getProductId(),
            'mode' => \XLite::getController()->getConfigurationMode(),
        ];
    }

    /**
     * @return array
     */
    public function getPanelParams()
    {
        return [
            'click_action' => [
                'widgetClass' => 'XC\BuyButton\View\FormField\Select\ClickAction',
                'widgetParams' => [
                    AFormField::PARAM_ATTRIBUTES => ['v-model' => 'click_action']
                ]
            ],
            'language' => [
                'widgetClass' => 'XC\BuyButton\View\FormField\Select\Language',
                'widgetParams' => [
                    AFormField::PARAM_ATTRIBUTES => ['v-model' => 'language'],
                ]
            ]
        ];
    }

    /**
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return BuyButton\Main::getSkinDir() . 'configuration.twig';
    }
}
