<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View;

use XCart\Extender\Mapping\ListChild;

/**
 * Product selections page view
 *
 * @ListChild (list="admin.center", zone="admin")
 */
class ProductChooser extends \XLite\View\ProductSelections
{
    /**
     * Return list of allowed targets
     *
     * @return array
     */
    public static function getAllowedTargets()
    {
        return ['buy_button_product_chooser'];
    }

    /**
     * Returns widget inner items list class
     *
     * @return string
     */
    protected function getItemsListClass()
    {
        return 'XC\BuyButton\View\ItemsList\Model\ProductChooser';
    }

    /**
     * Defines the search panel view class
     *
     * @return string
     */
    protected function getSearchPanelView()
    {
        return 'XC\BuyButton\View\SearchPanel\ProductChooser';
    }
}
