<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\Product;

use XCart\Extender\Mapping\ListChild;
use XC\BuyButton;

/**
 * @ListChild (list="bb-configuration.preview", zone="admin", weight="100")
 */
class Preview extends \XLite\View\AView
{
    /**
     * @inheritdoc
     */
    public function getJSFiles()
    {
        return [
            BuyButton\Main::getSkinDir() . 'preview/product_preview.js'
        ];
    }

    /**
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return BuyButton\Main::getSkinDir() . 'preview/product_preview.twig';
    }
}
