<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\Product;

use XC\BuyButton;

/**
 *
 */
class Embeddable extends \XLite\View\AView
{
    public const API_VERSION = 'v1';
    public const PARAM_IFRAME_WIDTH = 'iframe_width';
    public const PARAM_IFRAME_HEIGHT = 'iframe_height';

    protected $identifier;

    /**
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return $this->isDeveloperMode()
            ? BuyButton\Main::getSkinDir() . 'product/embeddable.twig'
            : BuyButton\Main::getSkinDir() . 'product/embeddable.min.twig';
    }

    /**
     * Define widget parameters
     *
     * @return void
     */
    protected function defineWidgetParams()
    {
        parent::defineWidgetParams();

        $this->widgetParams += [
            static::PARAM_IFRAME_WIDTH => new \XLite\Model\WidgetParam\TypeInt('Iframe width', $this->getDefaultIframeWidth()),
            static::PARAM_IFRAME_HEIGHT => new \XLite\Model\WidgetParam\TypeInt('Iframe height', $this->getDefaultIframeHeight()),
        ];
    }

    /**
     * Returns executor string url
     *
     * @return string
     */
    protected function getScriptUrl()
    {
        $js = $this->isDeveloperMode()
            ? BuyButton\Main::getSkinDir() . 'product/embeddable.js'
            : BuyButton\Main::getSkinDir() . 'product/embeddable.min.js';

        $url = \XLite\Core\Layout::getInstance()->getResourceWebPath(
            $js,
            \XLite\Core\Layout::WEB_PATH_OUTPUT_FULL,
            \XLite::INTERFACE_WEB,
            \XLite::ZONE_ADMIN
        );

        $webDir = \Includes\Utils\ConfigParser::getOptions(['host_details', 'web_dir']) . '/';
        if (strpos($url, $webDir) === 0) {
            $url = substr($url, strlen($webDir));
        }

        return $url;
    }

    /**
     * @return string
     */
    protected function getContainerId()
    {
        if (!isset($this->identifier)) {
            $this->identifier = 'product-card-' . uniqid();
        }

        return $this->identifier;
    }

    /**
     * @return integer
     */
    protected function getProductId()
    {
        return \XLite\Core\Request::getInstance()->product_id ?? 0;
    }

    /**
     * @return string
     */
    protected function getAttributeValues()
    {
        return \XLite\Core\Request::getInstance()->attribute_values ?? '';
    }

    /**
     * @return integer
     */
    protected function getIframeWidth()
    {
        return $this->getParam(self::PARAM_IFRAME_WIDTH);
    }

    /**
     * @return integer
     */
    protected function getIframeHeight()
    {
        return $this->getParam(self::PARAM_IFRAME_HEIGHT);
    }

    /**
     * @return integer
     */
    protected function getDefaultIframeWidth()
    {
        return is_string(\XLite\Core\Request::getInstance()->iframe_width)
            ? \XLite\Core\Request::getInstance()->iframe_width
            : \XLite::getController()->getDefaultIframeWidth();
    }

    /**
     * @return integer
     */
    protected function getDefaultIframeHeight()
    {
        return is_string(\XLite\Core\Request::getInstance()->iframe_height)
            ? \XLite\Core\Request::getInstance()->iframe_height
            : \XLite::getController()->getDefaultIframeHeight();
    }

    /**
     * @return string
     */
    protected function getClickAction()
    {
        return is_string(\XLite\Core\Request::getInstance()->click_action)
            ? \XLite\Core\Request::getInstance()->click_action
            : BuyButton\View\Product\Details\Admin\Button::VALUE_OPEN_DETAILS;
    }

    /**
     * @return string
     */
    protected function getLanguage()
    {
        return is_string(\XLite\Core\Request::getInstance()->language)
            ? \XLite\Core\Request::getInstance()->language
            : BuyButton\View\FormField\Select\Language::OPTION_CUSTOMER_SESSION;
    }

    /**
     * @return string
     */
    protected function getCurrency()
    {
        return is_string(\XLite\Core\Request::getInstance()->currency)
            ? \XLite\Core\Request::getInstance()->currency
            : 'default';
    }

    /**
     * @return string
     */
    protected function getApiVersion()
    {
        return self::API_VERSION;
    }

    /**
     * @return string
     */
    protected function getShopEndpoint()
    {
        return \XLite::getInstance()->getShopURL(
            \XLite\Core\Converter::buildURL(
                'buy_button',
                '',
                [],
                \XLite::getInstance()->getCustomerScript()
            )
        );
    }
}
