<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\Product\Details\Admin;

use XCart\Extender\Mapping\ListChild;
use XC\BuyButton;

/**
 * Product widget
 *
 * @ListChild (list="bb-product.card", zone="admin", weight="200")
 * @ListChild (list="bb-product.card", zone="customer", weight="200")
 */
class Name extends \XLite\View\Product\Details\Customer\Widget
{
    /**
     * Return the specific widget service name to make it visible as specific CSS class
     *
     * @return null|string
     */
    public function getFingerprint()
    {
        return 'widget-fingerprint-name';
    }

    /**
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return BuyButton\Main::getSkinDir() . 'product/details/name.twig';
    }
}
