<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\Product\Details\Admin;

use XCart\Extender\Mapping\ListChild;
use XC\BuyButton;

/**
 * Product widget
 *
 * @ListChild (list="bb-product.card", zone="admin", weight="100")
 * @ListChild (list="bb-product.card", zone="customer", weight="100")
 */
class Image extends \XLite\View\Product\Details\Customer\Image
{
    /**
     * Register files from common repository
     *
     * @return array
     */
    public function getCommonFiles()
    {
        $list = [];

        return $list;
    }

    /**
     * Register CSS files
     *
     * @return array
     */
    public function getJSFiles()
    {
        $list = [];

        return $list;
    }

    /**
     * @return string
     */
    protected function getTemplate()
    {
        return BuyButton\Main::getSkinDir() . 'product/details/image.twig';
    }

    /**
     * Get image alternative text
     *
     * @param \XLite\Model\Base\Image $image Image
     * @param integer                 $i     Image index OPTIONAL
     *
     * @return string
     */
    public function getAlt($image, $i = null)
    {
        return $image && $image->getAlt()
            ? $image->getAlt()
            : $this->getProduct()->getName();
    }

    /**
     * Return the max image width depending on whether it is a quicklook popup, or not
     *
     * @return integer
     */
    protected function getWidgetMaxWidth()
    {
        return 230;
    }

    /**
     * Get product image container max height
     *
     * @return integer
     */
    protected function getWidgetMaxHeight()
    {
        return 230;
    }
}
