<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\BuyButton\View\Product\Details\Admin;

use XCart\Extender\Mapping\ListChild;
use XC\BuyButton;

/**
 * Product widget
 *
 * @ListChild (list="bb-product.card", zone="admin", weight="400")
 * @ListChild (list="bb-product.card", zone="customer", weight="400")
 */
class Button extends \XLite\View\Product\Details\Customer\Widget
{
    public const PARAM_CLICK_ACTION = 'clickAction';
    public const VALUE_OPEN_DETAILS = 'details';
    public const VALUE_ADD_TO_CART = 'add';

    /**
     * Define widget parameters
     *
     * @return void
     */
    protected function defineWidgetParams()
    {
        parent::defineWidgetParams();

        $this->widgetParams += [
            static::PARAM_CLICK_ACTION => new \XLite\Model\WidgetParam\TypeString('Action on click', $this->getDefaultClickAction()),
        ];
    }

    /**
     * Return the specific widget service name to make it visible as specific CSS class
     *
     * @return null|string
     */
    public function getFingerprint()
    {
        return 'widget-fingerprint-button';
    }

    /**
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return BuyButton\Main::getSkinDir() . 'product/details/button.twig';
    }

    /**
     * @return mixed|string
     */
    protected function getDefaultClickAction()
    {
        return \XLite\Core\Request::getInstance()->click_action ?? self::VALUE_OPEN_DETAILS;
    }

    /**
     * @return string
     */
    protected function getJsCode()
    {
        return 'window.open("' . $this->getActionUrl() . '");';
    }

    /**
     * @return mixed
     */
    protected function getActionUrl()
    {
        $action = $this->getParam(self::PARAM_CLICK_ACTION);

        switch ($action) {
            case self::VALUE_ADD_TO_CART:
                return $this->getAddToCartUrl();
                 break;

            case self::VALUE_OPEN_DETAILS:
            default:
                return $this->getProductUrl();
                 break;
        }
    }

    /**
     * @return string
     */
    protected function getButtonLabel()
    {
        $action = $this->getParam(self::PARAM_CLICK_ACTION);

        switch ($action) {
            case self::VALUE_ADD_TO_CART:
                return 'Add to cart';
                 break;

            case self::VALUE_OPEN_DETAILS:
            default:
                return 'Show product';
                 break;
        }
    }
}
